/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.system;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import org.w3c.dom.Node;

public class RemotePartitionSystem
extends RemoteMachineSystem {
    private static final String TRACE_MASKT = "XPARPART";
    private static final String TRACE_MASKF = "XPARPARF";
    private static final String TRACE_MASKD = "XPARPARD";
    public RemotePartitionSystemPersistentData rparPD = null;

    public RemotePartitionSystem() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.initPersistentData();
    }

    public RemotePartitionSystem(String machineType, String machineModel, String machineSerial) {
        super(machineType, machineModel, machineSerial);
        this.initPersistentData();
    }

    public RemotePartitionSystem(String machineType, String machineModel, String machineSerial, String partitionName, String partitionSlotId, String partitionHostName) {
        this(machineType, machineModel, machineSerial);
        this.rparPD.partitionName = partitionName;
        this.rparPD.partitionSlotId = partitionSlotId;
        this.rparPD.partitionHostName = partitionHostName;
        if (partitionHostName != null) {
            this.addIPAddr(partitionHostName);
        }
    }

    public RemotePartitionSystem(PersistentData data) throws PersistenceException {
        super(((RemotePartitionSystemPersistentData)data).superData);
        this.initPersistentData();
        this.rparPD.partitionName = ((RemotePartitionSystemPersistentData)data).partitionName;
        this.rparPD.partitionSlotId = ((RemotePartitionSystemPersistentData)data).partitionSlotId;
        this.rparPD.partitionHostName = ((RemotePartitionSystemPersistentData)data).partitionHostName;
    }

    private void initPersistentData() {
        this.rparPD = new RemotePartitionSystemPersistentData();
        this.rparPD.superData = super.getPersistentData();
    }

    public String getPartitionName() {
        return this.rparPD.partitionName;
    }

    public String getPartitionSlotId() {
        return this.rparPD.partitionSlotId;
    }

    public String getPartitionHostName() {
        return this.rparPD.partitionHostName;
    }

    public PersistentData getPersistentData() {
        if (this.rparPD.superData == null) {
            this.rparPD.superData = super.getPersistentData();
        }
        return this.rparPD;
    }

    public static class RemotePartitionSystemPersistentData
    implements PersistentData,
    XMLEncodeable {
        private static final long serialVersionUID = -1828627933387674612L;
        public PersistentData superData = null;
        public String partitionName = null;
        public String partitionSlotId = null;
        public String partitionHostName = null;

        public void toXML(StringBuffer sb) {
            sb.append("<PersistentData class=\"" + this.getClass().getName() + "\"");
            sb.append(" partitionName=\"" + XMLHelper.convertQuote(this.partitionName) + "\"");
            sb.append(" partitionSlotId=\"" + XMLHelper.convertQuote(this.partitionSlotId) + "\"");
            sb.append(" partitionHostName=\"" + XMLHelper.convertQuote(this.partitionHostName) + "\"");
            sb.append("/>");
        }

        public void fromXML(Node node) {
            Node pdNode = node.getChildNodes().item(0);
            if (!pdNode.getNodeName().equals("PersistentData")) {
                Trace.trace(RemotePartitionSystem.TRACE_MASKT, "<-> RemotePartitionSystemPersistentData.fromXML: necessary 'PersistentData' node not found");
                return;
            }
            this.partitionName = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(pdNode, "partitionName"));
            this.partitionSlotId = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(pdNode, "partitionSlotId"));
            this.partitionHostName = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(pdNode, "partitionHostName"));
        }
    }
}

